this.name        = "ups_docs"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Docs missions of UPS Courier"; 
this.version     = "1.4.2"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.71") > 0)
    {
        // Oolite version is older than 1.71.
        log("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Parcel missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
        delete this.missionChoiceWasReset
        delete this.playerEnteredNewGalaxy
    }
}

this.reset = function()
{
    this.choiceWarning = false
    this.offerWarning = false
    this.mark = false
}

this.shipWillDockWithStation = function()
{
    if(missionVariables.offering) {missionVariables.offering = null; this.offerWarning = true}
    if(mission.choice && mission.choice != "") {mission.choice = null; this.choiceWarning = true}
}

this.shipDockedWithStation = function()
{
        if(player.docked) this.ups_missionOffers()
}

this.longRangeChart = function()
{
    if(guiScreen == "GUI_SCREEN_LONG_RANGE_CHART")
    {
        if(this.mark) {mission.unmarkSystem(missionVariables.ups_dplanet); this.mark = false}
        else {mission.markSystem(missionVariables.ups_dplanet); this.mark = true}
    }
    else
    {
        this.missionChartTimer.stop()
        mission.unmarkSystem(missionVariables.ups_dplanet)
        this.mark = true // Keep this selected system.
        missionVariables.offering = null
        mission.choice = null
        if(player.status == "STATUS_DOCKED") this.ups_missionOffers()
        //without being docked, "player.dockedStation.isMainStation" generates errors in the log.
    }
}

this.ups_missionOffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return;
    if(this.choiceWarning) {mission.runMissionScreen("ups_warning", "UPS.png"); this.choiceWarning = false; return}
    if(this.offerWarning) {mission.runMissionScreen("ups_warning3", "UPS.png"); this.offerWarning = false; return}
    if (player.dockedStation.isMainStation)
    {
        if(!missionVariables.ups_docs)
        {   // setting up all mission variables.
            missionVariables.ups_docs = "NO" 
            missionVariables.ups_dcount = 0 
            missionVariables.ups_planet = 0 
            missionVariables.ups_cplanet = 0 
            missionVariables.ups_difference = 0 
            missionVariables.ups_parcel = "NO" 
            missionVariables.ups_pcount = 0 
            missionVariables.ups_pplanet = 0 
            missionVariables.ups_container = "NO"
            missionVariables.ups_ccount = 0
            missionVariables.ups_c1count = 0
            missionVariables.ups_c2count = 0 
            missionVariables.ups_ecount = 0 
            missionVariables.ups_ccount = 0 
            missionVariables.ups_cplanet = 0
            missionVariables.ups_galcop_punishment = 0
            missionVariables.ups_galaxy = galaxyNumber  // not used anymore. Only stored for compatibility with plist script.
	// galaxyNumber is GLOBAL and may change to player.galaxyNumber  in future!!!
        }
        if(missionVariables.ups_docs == "YES")
        {
            if(player.bounty < 3 && system.government == 6 && !mission.choice)
            {
                missionVariables.ups_docs_appearance = expandDescription("[ups_numbers]") + " " + expandDescription("[ups_condition]") + " " +  expandDescription("[%I]") 
                if (missionVariables.ups_dcount == 0){mission.runMissionScreen("ups_docs_1st_offer", "UPS.png", "ups_docs_accepted_yesno")}
                else {mission.runMissionScreen("ups_docs_offer", "UPS.png", "ups_docs_accepted_yesno")}
                missionVariables.offering = "UPS_DOCS"
            }
        }
        if(missionVariables.ups_docs == "SMALL_DELIVERY" && system.government == 6)
        {
            if(missionVariables.ups_dplanet ==  system.ID)
            {
                missionVariables.ups_docs = "ACCEPTED"
                mission.runMissionScreen("ups_back_at_home", "UPS.png")
            }
            else
            {
                missionVariables.ups_docs = "NOT_NOW"
                player.credits += 100
                if(missionVariables.ups_dcount == 0)
                {mission.setBackgroundImage("UPS.png");mission.runMissionScreen("ups_docs_1st_unloading", "UPS.png") }
                else{mission.runMissionScreen("ups_docs_unloading")}
                mission.setInstructionsKey()
                missionVariables.ups_dcount++
                missionVariables.ups_docs_appearance = null
                this.increaseReputation()
            }
        }
        if(missionVariables.ups_docs == "LOGGING")
        {
            if(system.government == 6 && !mission.choice && missionVariables.ups_dplanet != system.ID)
            {
                    let ups_choices = ""
                    if (oolite.compareVersion("1.72") > 0) ups_choices = "ups_docs_accepted_yesnolook"
                    else ups_choices = "ups_docs_accepted_yesno" // untill I can proper show the galactic map
                    mission.runMissionScreen("ups_docs_offer2", "UPS.png", ups_choices)
                    missionVariables.offering = "UPS_DOCS2"
            }
        }
        if(missionVariables.ups_docs == "SPECIAL_DELIVERY")
        {
            if(missionVariables.ups_dplanet == system.ID && system.government == 6 && !missionVariables.ups_docbriefing)
            {
                    mission.runMissionScreen("ups_docs_unloading2a", "UPS.png")
                    mission.setInstructionsKey("ups_docs_small3")
                    missionVariables.ups_docbriefing = "YES"
            }
        }
        if(missionVariables.ups_docs == "ASTEROID_OFFER")
        {
            if(system.countShipsWithRole("asteroid") < 15 && !mission.choice)
            {
                    mission.runMissionScreen("ups_docs_asteroid1", "UPS.png", "ups_docs_asteroid_yesno")
                    missionVariables.offering = "UPS_DOCS_ASTEROID"
            }
        }
    }
    if ((player.dockedStation.shipDescription == "Sun Research Station Alpha" || player.dockedStation.shipDescription == "Sun Research Station Beta" || player.dockedStation.shipDescription == "Sun Research Station Delta" || player.dockedStation.shipDescription == "Sun Research Station Omega"))
    {
        if(missionVariables.ups_docs == "SPECIAL_DELIVERY")
        {
            missionVariables.ups_docs = "NOT_NOW", 
            player.credits += 250 
            mission.runMissionScreen("ups_docs_unloading2")
            mission.setInstructionsKey()
            missionVariables.ups_dcount++
            mission.unmarkSystem(missionVariables.ups_dplanet)
            this.increaseReputation()
            if(player.dockedStation.shipDescription == "Sun Research Station Alpha" && !missionVariables.ups_sun )
            {
                missionVariables.ups_sun = "NOT_NOW"
                missionVariables.ups_sunbase = "YES"
                missionVariables.ups_sunvisits = 0
                missionVariables.ups_splanetname = missionVariables.ups_dplanetname
                missionVariables.ups_splanet = missionVariables.ups_dplanet
            }
            missionVariables.ups_dplanetname = null
            missionVariables.ups_docbriefing = null
        }
    }
}

this.ups_choiceEvaluation = function()
{
    if (missionVariables.offering == "UPS_DOCS")
    {
        if(mission.choice == "YESDoc")
        {
            missionVariables.offering = null
            mission.setInstructionsKey("ups_docs_small") 
            missionVariables.ups_docs = "ACCEPTED" 
            missionVariables.ups_dplanet = system.ID 
            mission.choice = null
        }
        else
        {
            if (mission.choice == "NODoc")
            {
                missionVariables.ups_docs = "NOT_NOW" 
                missionVariables.offering = null
                missionVariables.ups_docs_appearance = null
                mission.choice = null
                if (Math.random() < 0.5){this.decreaseReputation()}
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
    if (missionVariables.offering == "UPS_DOCS2")
    {
        this.mark = false
        if(mission.choice == "YESDoc")
        {
            mission.setInstructionsKey("ups_docs_small2") 
            missionVariables.ups_docs = "SPECIAL_DELIVERY" 
            missionVariables.offering = null
            mission.choice = null
            mission.markSystem(missionVariables.ups_dplanet) 
        }
        else
        {
            if(mission.choice == "LOOKDoc")
            {
                player.call("setGuiToLongRangeChartScreen")
                if(this.missionChartTimer) this.missionChartTimer.start()
                else this.missionChartTimer = new Timer(this, this.longRangeChart, 0.5, 0.5)
            }
            else
            {
                if (mission.choice == "NODoc")
                {
                    missionVariables.ups_docs = "NOT_NOW" 
                    missionVariables.offering = null
                    mission.choice = null
                } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
    }
    if (missionVariables.offering == "UPS_DOCS_ASTEROID")
    {
        if(mission.choice == "YESDoc")
        {
            missionVariables.offering == "UPS_DOCS_ASTEROID2"
            mission.runMissionScreen("ups_docs_asteroid2")
            mission.setInstructionsKey("ups_docs_asteroid_short") 
            missionVariables.ups_docs = "ASTEROID"
            missionVariables.ups_asteroid_count = 16
            missionVariables.offering = null
            mission.choice = null
        }
        else
        {
            if (mission.choice == "NODoc")
            {
                missionVariables.ups_docs = "NOT_NOW" 
                missionVariables.offering = null
                mission.choice = null
            } else {mission.runMissionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
        }
    }
}

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    if(mission.choice) this.ups_choiceEvaluation()
    this.ups_missionOffers()
}

this.missionChoiceWasReset = function()
{
    if(!player.docked) return;
    this.ups_missionOffers()
}

this.shipExitedWitchspace = function()
{
    if(system.isInterstellarSpace) return;
    this.setUpShips_ups_docs();
    if(missionVariables.ups_docs == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_docs = "NO"}
    if(missionVariables.ups_docs == "ACCEPTED")
        missionVariables.ups_docs = "SMALL_DELIVERY"; system.legacy_addSystemShips("trader", 2, Math.random())
    if(missionVariables.ups_docs == "NO")
    {
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.2 && system.government == 6)
            missionVariables.ups_docs = "YES"
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.05 && system.government == 6 && missionVariables.ups_dcount > 5 && !system.goneNova) // add "player.contractReputation>3" for 1.72+
        {
            missionVariables.ups_docs = "LOGGING"; 
            missionVariables.ups_dplanet = system.ID; 
            missionVariables.ups_dplanetname = expandDescription("[%H]")
        }
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.035 && missionVariables.ups_dcount > 20 && system.countShipsWithRole("asteroid") < 13)
            missionVariables.ups_docs = "ASTEROID_OFFER"
    }
    else
    {
        if (missionVariables.ups_docs == "ASTEROID")
        {
            missionVariables.ups_docs = "NOT_NOW"
            missionVariables.ups_asteroid_count = null
            mission.setInstructionsKey() 
        }
        if (missionVariables.ups_docs == "SMALL_DELIVERY")
        {system.legacy_addSystemShips("trader", 1, Math.random()); system.legacy_addSystemShips("trader", 1, Math.random())}
        if (missionVariables.ups_docs == "SPECIAL_DELIVERY" && system.government < 2)
        {
            system.legacy_addSystemShips("ups_pirate", 10, 1);
            system.legacy_addSystemShips("ups_pirate", 10, 0.15);
            system.legacy_addSystemShips("pirate", 5, Math.random())
            let docpirates1 = system.shipsWithPrimaryRole("ups_pirate");
            for (let i=0; i<docpirates1.length; i++)
                if(docpirates1[i]) //could have already been destroyed
                {
                    if(docpirates1[i].AI == "pirateAI.plist") docpirates1[i].switchAI("upsSecDocPirateAI.plist")
                }
            let docpirates2 = system.shipsWithPrimaryRole("pirate");
            for (let i=0; i<docpirates2.length; i++)
                if(docpirates2[i]) //could have already been destroyed
                {
                    if(docpirates2[i].AI == "pirateAI.plist") docpirates2[i].switchAI("upsSecDocPirateAI.plist")
                }
            system.legacy_addSystemShips("hunter", 3, Math.random())
            if(missionVariables.ups_dcount > 15)
            {system.legacy_addSystemShips("ups_pirate_leader", 1, 0.35);system.legacy_addSystemShips("ups_pirate_leader", 2, 0.85)}
        }
    }
}

this.playerEnteredNewGalaxy = function()
{
    // reset missions on galactic jump
    if(missionVariables.ups_docs == "LOGGING" || missionVariables.ups_docs == "SPECIAL_DELIVERY")
    {
        missionVariables.ups_dplanetname = null
        missionVariables.ups_docsbriefing = null
        missionVariables.ups_docs = "NOT_NOW"
        mission.setInstructionsKey()
        mission.unmarkSystem(missionVariables.ups_dplanet)
        missionVariables.ups_dplanet = null
        missionVariables.ups_docs_appearance = null
    }
}

this.setUpShips_ups_docs = function()
{
    if(missionVariables.ups_docs == "SPECIAL_DELIVERY" && missionVariables.ups_dplanet == system.ID)
    {
        let addSunskimmers = false
        if(!missionVariables.ups_sun)
        {
            if(system.countShipsWithRole("ups_dependance") == 0)
            {system.legacy_addShipsAt("ups_dependance", 1, "sps", 0, 0, 2.6); addSunskimmers = true}
        }
        else
        {
            if(system.countShipsWithRole("ups_dependance2") == 0)
            {system.legacy_addShipsAt("ups_dependance2", 1, "sps", 0, 0, 2.6); addSunskimmers = true}
        }
        if(addSunskimmers)
        {
            system.legacy_addShipsAt("ups-sunskim", 3, "sps", 0, 0, 2.6)
            system.legacy_addShipsAt("ups_shuttle", 8, "sps", 0, 0, 2.6)
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sun-police", 4, "spu", 0, 0, (Math.random()*0.8 + 0.1))
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            if(worldScripts.transportSchedule  || worldScripts.transportschedule !== undefined)  // has Transports.OXP installed
            {
                system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
                system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
                system.legacy_addShipsAt("fueltransport", 1, "spu", 0, 0, Math.random())
            }
        }
    }
}

this.shipLaunchedFromStation = function()
{
    this.setUpShips_ups_docs()
    if(missionVariables.ups_docs == "ASTEROID")
    {
        if(system.countShipsWithRole("ups-miner") == 0 && missionVariables.ups_asteroid_count > 8)
        {
            missionVariables.ups_asteroids = 15
            system.legacy_addShipsAt("asteroid", 15, "pwu", 0, 0, -0.5)
            system.legacy_addShipsAt("asteroid", 15, "pwu", 0, 0, -0.7)
            system.legacy_addShipsAt("ups-miner", 2, "pwu", 0, 0, -0.6)
            system.legacy_addShipsAt("ups-miner", 5, "pwu", 0, 0, -0.8)
            system.legacy_addShipsAt("ups-miner", 5, "pwu", 0, 0, -1.0)
            missionVariables.ups_asteroids = null
        }
    }
}

// temp fix for 1.71/1.72 compatibility.
this.increaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("increaseContractReputation")
        else player.increaseContractReputation()
}

this.decreaseReputation = function()
{
        if (oolite.compareVersion("1.72") > 0) player.call("decreaseContractReputation")
        else player.decreaseContractReputation()
}